using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    static void Main()
    {
        string[] ulaz = Console.ReadLine().Split();
        int n = int.Parse(ulaz[0]);
        int k = int.Parse(ulaz[1]);

        if (!TacanUnos(n, k))
        {
            Console.WriteLine("Nevažeci unos.");
            return;
        }

        List<int> pozicije = new List<int>();
        List<int> brzine = new List<int>();

        if (!UcitavanjePozicijeIBrzine(n, pozicije, brzine))
        {
            Console.WriteLine("Nevažeci unos.");
            return;
        }

        List<double> preticanja = TraženjePreticanja(pozicije, brzine);
        preticanja.Sort();

        Console.WriteLine(preticanja[k]);
        Console.ReadKey();
    }

    static bool TacanUnos(int n, int k)
    {
        return (n >= 1 && n <= 150000) && (k >= 1 && k <= n * (n - 1) / 2);
    }

    static bool UcitavanjePozicijeIBrzine(int n, List<int> pozicije, List<int> brzine)
    {
        for (int i = 0; i < n; i++)
        {
            string[] ulazi = Console.ReadLine().Split();
            int pozicija = int.Parse(ulazi[0]);
            int brzina = int.Parse(ulazi[1]);

            if (!TacnaPozicijaIBrzina(pozicija, brzina))
            {
                return false;
            }

            pozicije.Add(pozicija);
            brzine.Add(brzina);
        }

        return true;
    }

    static bool TacnaPozicijaIBrzina(int pozicija, int brzina)
    {
        return (pozicija >= 1 && pozicija <= 1000000000) && (brzina >= 1 && brzina <= 100000000);
    }

    static List<double> TraženjePreticanja(List<int> pozicije, List<int> brzine)
    {
        List<double> preticanja = new List<double>();

        for (int i = 0; i < pozicije.Count - 1; i++)
        {
            for (int j = 0; j < pozicije.Count - i - 1; j++)
            {
                if (brzine[i + j + 1] != brzine[i])
                {
                    preticanja.Add((double)(pozicije[i] - pozicije[i + j + 1]) / (brzine[i + j + 1] - brzine[i]));
                }
            }
        }

        return preticanja;
    }
}